import pandas as pd   
import pickle

# Read the fastfood data
fastfood = pd.read_csv("fastfood.csv")

# Define the thresholds
max_calories = 500
max_total_fat = 20
max_sodium = 800
max_sugar = 15
min_protein = 10
 
# Create healthy and unhealthy dataframes
healthy_items = fastfood[(fastfood['calories'] <= max_calories) &
                         (fastfood['total_fat'] <= max_total_fat) &
                         (fastfood['sodium'] <= max_sodium) &
                         (fastfood['sugar'] <= max_sugar) &
                         (fastfood['protein'] >= min_protein)] 
 
unhealthy_items = fastfood[~fastfood.index.isin(healthy_items.index)]

print(unhealthy_items)
pickle.dump(unhealthy_items,open("./ref_result/unhealthy_items.pkl","wb"))
